IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_GLB_USU_EST_SNGPC_BLOQUEIA_SNGPC_ANONIMIZADO' )
BEGIN
	DROP TRIGGER TRG_GLB_USU_EST_SNGPC_BLOQUEIA_SNGPC_ANONIMIZADO
END
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO 
'Objetivo............: Tratamento para nao alteracao do SNGPC Anonimizado
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 30/07/2021
'Alterado por........: 
'Criado por..........: Marcos Barros 
'=======================================================================================
*/
CREATE TRIGGER TRG_GLB_USU_EST_SNGPC_BLOQUEIA_SNGPC_ANONIMIZADO ON GLB_USU_EST_SNGPC FOR UPDATE AS
	DECLARE @CD_USU INT
	IF UPDATE (CD_USU)
	BEGIN
		RETURN;
	END
	SET @CD_USU = ISNULL((SELECT CD_USU FROM inserted),0);

	IF EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO 
				WHERE
					CD_PESSOA = @CD_USU
					AND TP_PROC = 4)
	  begin
		RAISERROR ('ALTERACAO NO PERMITIDA, CADASTRO ANONIMIZADO!',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end

GO

ALTER TABLE GLB_USU_EST_SNGPC ENABLE TRIGGER TRG_GLB_USU_EST_SNGPC_BLOQUEIA_SNGPC_ANONIMIZADO


